<?php
/* --------------------------------------------------------------
 malibu.lang.inc.php 2021-08-09
 Gambio GmbH
 http://www.gambio.de

 Copyright (c) 2021 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

$t_language_text_section_content_array = [
    'basics.title' => 'Basic',
    'basics.responsive.title' => 'Responsive',
    'basics.responsive.options.main-heading-mobile-visibility' => 'Visible on Mobile',

    'basics.general.title' => 'General',
    'basics.general.options.brand-primary' => 'Primary Color',
    'basics.general.options.brand-secondary' => 'Secondary Color',
    'basics.general.options.gx-logo' => 'Logo',

    'basics.typo.title' => 'Typography',
    'basics.typo.options.font-family-sans-serif' => 'Font Family',
    'basics.typo.options.text-color' => 'Text Color',
    'basics.typo.options.font-size-base' => 'Font Size',
    'basics.typo.options.gx-font-import-url' => 'Google Web Font Url',

    'basics.background.title' => 'Background',
    'basics.background.options.gx-body-bg-color' => 'Color',
    'basics.background.options.gx-body-bg-image-url' => 'Picture',

    'basics.navigationMenu.title' => 'Navigation Menu',
    'basics.navigationMenu.options.gx-cat-navbar-bg-color' => 'Background Color',
    'basics.navigationMenu.options.navbar-default-link-color' => 'Links Color',
    'basics.navigationMenu.options.unique-id' => 'Font',

    'areas.header.title' => 'Header',
    'areas.headervariant.title' => 'Header Variants',
    'areas.header.variants.title' => 'Variants',
    'areas.header.variants.headerVariant.options.fullscreen' => 'Fullscreen',
    'areas.header.variants.headerVariant.options.boxed' => 'Boxed',
    'areas.header.variants.headerVariant.options.bordered' => 'Bordered',
    'areas.header.variants.headerVariant.options.hero' => 'Hero',
    'areas.header.variants.headerVariant.options.default' => 'Default',
    'areas.header.variants.headerVariant.options.default.thumbnail' => '\/\/placehold.it\/800x150?text=Default',

    'areas.pages.title' => 'Pages',
    'areas.pages.homepage.title' => 'Homepage',
    'areas.pages.homepage.background.title' => 'Background',
    'areas.pages.homepage.background.options.homepage-background-option' => 'Background (label)',

    'areas.pages.homepage.typo.title' => 'Typography',
    'areas.pages.homepage.typo.options.pages-homepage-typo' => 'Font Family',
    'areas.pages.homepage.typo.options.pages-homepage-text-color' => 'Text Color',

    'areas.pages.homepage.single-page.title' => 'Single Page',
    'areas.pages.homepage.single-page.single-page-sub.title' => 'Single Page Sub',
    'areas.pages.homepage.single-page.single-page-sub-main-section.title' => 'Main Section',
    'areas.pages.homepage-single-page.single-page-sub-main-section.options.general.title' => 'General',
    'areas.pages.homepage-single-page.single-page-sub-main-section.options.general.options.main-section-name' => 'Title',
    'areas.pages.homepage-single-page.single-page-sub-main-section.options.general.options.main-section-id' => 'ID',
    'areas.pages.homepage-single-page.single-page-sub-main-section.options.general.options.main-section-class' => 'Class',
    'areas.pages.homepage-single-page.single-page-sub-main-section.options.general.options.main-section-height' => 'Height',
    'areas.pages.homepage-single-page.single-page-sub-main-section.options.general.options.main-section-position' => 'Position',
    'areas.pages.homepage-single-page.single-page-sub-main-section.options.general.options.sub-page-text-color' => 'Text Color',
    'areas.pages.homepage-single-page.single-page-sub-main-section.options.general.options.main-heading-bg-image' => 'Background',
    'areas.pages.homepage-single-page.single-page-sub-main-section.options.general.options.sub-page-typo' => 'Font Family',

    'areas.pages.homepage-single-page.grid.title' => 'Das Grid',
    'areas.pages.homepage-single-page.grid.options.fullwidth' => '100%',
    'areas.pages.homepage-single-page.grid.options.fifty-fifty' => '50%x50%',
    'areas.pages.homepage-single-page.grid.options.thirty-three-sixty-six' => '33%x66%',
    'areas.pages.homepage-single-page.grid.options.sixty-six-thirty-three' => '66%x33%',
    'areas.pages.homepage-single-page.grid.options.twenty-five-seventy-five' => '25%x75%',
    'areas.pages.homepage-single-page.grid.options.seventy-five-twenty-five' => '75%x25%',
    'areas.pages.homepage-single-page.grid.options.three-thirty-three' => '33%x33%x33%',
    'areas.pages.homepage-single-page.grid.options.four-twenty-five' => '25%x25%x25%x25%',

    'areas.pages.homepage-single-page.responsive.title' => 'Responsive',
    'areas.pages.homepage-single-page.responsive.options.main-heading-mobile-visibility' => 'Visible on Mobile',
    'areas.pages.homepage-single-page.responsive.options.main-heading-image-direction' => 'Landscape Image',

    'areas.pages.homepage-single-page.distances.title' => 'Distances',
    'areas.pages.homepage-single-page.distances.option.main-heading-margin' => 'Margin',

    'areas.pages.homepage-single-page.border.title' => 'Border',
    'areas.pages.homepage-single-page.border.options.main-heading-border' => 'Border width',
    'areas.pages.homepage-single-page.border.options.main-heading-style' => 'Style',
    'areas.pages.homepage-single-page.border.options.main-heading-border-color' => 'Color',

    'areas.footer.title' => 'Footer',
    'areas.footerVariant.title' => 'Footer Variants',
    'areas.footer.variants.title' => 'Variants',
    'areas.footer.variants.footerVariant.options.fullscreen' => 'Fullscreen',
    'areas.header.variants.headerVariant.options.fullscreen.thumbnail' => '//placehold.it/800x150?text=Header {Fullscreen}',
    'areas.footer.variants.footerVariant.options.boxed' => 'Boxed',
    'areas.header.variants.headerVariant.options.boxed.thumbnail' => '\/\/placehold.it\/800x150?text=Header {Boxed}',
    'areas.footer.variants.footerVariant.options.bordered' => 'Bordered',
    'areas.header.variants.headerVariant.options.bordered.thumbnail' => '\/\/placehold.it\/800x150?text=Header {Bordered}',
    'areas.footer.variants.footerVariant.options.hero' => 'Hero',
    'areas.header.variants.headerVariant.options.hero.thumbnail' => '\/\/placehold.it\/800x150?text=Header {Hero}',

    'areas.general.title' => 'General',
    'areas.general.layout.title' => 'Layout',
    'areas.general.layout.options.gx-body-wrap' => 'Framed Shop',
    'areas.general.layout.options.gx-topbar-wrap' => 'Framed Top Navigation',
    'areas.general.layout.options.gx-categories-wrap' => 'Framed Categories Bar',
    'areas.general.layout.options.gx-center-categories' => 'Framed Categories',
    'areas.general.layout.options.gx-header-fixed' => 'Fixed Header',
    'areas.general.layout.options.gx-header-wrap' => 'Framed Header',
    'areas.general.layout.options.gx-stage-wrap' => 'Framed Slider',
    'areas.general.layout.options.gx-footer-wrap' => 'Framed Footer',
    'areas.general.layout.options.gx-logo-horizontal' => 'Logo Horizontally Aligned',
    'areas.general.layout.options.gx-stage-below-header' => 'Slider Under Header',
    'areas.general.layout.options.screen-lg' => 'Maximum Width',
    'areas.general.layout.options.gx-body-padding-top' => 'Top Margin',
    'areas.general.layout.options.gx-body-padding-bottom' => 'Bottom Margin',

    'areas.general.colors.title' => 'Colors',
    'areas.general.colors.options.brand-primary' => 'Primary Color',
    'areas.general.colors.options.text-color' => 'Text Color',
    'areas.general.colors.options.link-color' => 'Link Color',
    'areas.general.colors.options.gx-breadcrumb-color' => 'Breadcrumb Color',
    'areas.general.colors.options.gx-no-rating-hint-color' => 'Color No Rating Hint',

    'areas.general.background.title' => 'Background',
    'areas.general.background.options.gx-body-bg' => 'Background',
    'areas.general.background.options.gx-wrapper-bg' => 'Container Background Color',

    'areas.general.font.title' => 'Font',
    'areas.general.font.options.gx-font-import-url' => 'Google-Webfonts-Url',
    'areas.general.font.options.pages-homepage-typo' => 'Font Family',
    'areas.general.font.options.font-size-base' => 'Font Size',
    'areas.general.font.options.font-size-h1' => 'Font Size H1',
    'areas.general.font.options.font-size-h2' => 'Font Size H2',
    'areas.general.font.options.font-size-h3' => 'Font Size H3',
    'areas.general.font.options.font-size-h4' => 'Font Size H4',
    'areas.general.font.options.font-size-h5' => 'Font Size H5',
    'areas.general.font.options.font-size-h6' => 'Font Size H6',
    'areas.general.font.options.headings-color' => 'Headings Color',
    'areas.general.font.options.headings-font-weight' => 'Font Weight',

    'areas.general.table.title' => 'Tables',
    'areas.general.table.options.gx-table-headline-color' => 'Text Color Table Head',
    'areas.general.table.options.gx-table-body-color-even' => 'Text Color Odd Column',
    'areas.general.table.options.gx-table-body-color-odd' => 'Text Color Even Column',
    'areas.general.table.options.gx-table-border-color' => 'Border Color',
    'areas.general.table.options.gx-table-even-row-bg' => 'Background Even Column',
    'areas.general.table.options.gx-table-odd-row-bg' => 'Background Odd Column',
    'areas.general.table.options.gx-table-bg' => 'Background Color',

    'areas.general.roundedCorners.title' => 'Border Radius',
    'areas.general.roundedCorners.options.border-radius-base' => 'Border Radius normal',
    'areas.general.roundedCorners.options.border-radius-large' => 'Border Radius big',
    'areas.general.roundedCorners.options.border-radius-small' => 'Border Radius small',
    'areas.general.roundedCorners.options.gx-wrapper-border-radius' => 'Border Radius Framed Shop',
    'areas.general.roundedCorners.options.gx-cat-navbar-border-radius' => 'Border Radius Horizontal Category Menu',
    'areas.general.roundedCorners.options.gx-cart-border-radius' => 'Border Radius Cart Total Box',

    'areas.general.pageUpButton.title' => 'Page-Up-Button',
    'areas.general.pageUpButton.options.gx-pageup-color' => 'Text Color',
    'areas.general.pageUpButton.options.gx-pageup-hover-color' => 'Text Color Hover',
    'areas.general.pageUpButton.options.gx-pageup-bg-color' => 'Background Color',
    'areas.general.pageUpButton.options.gx-pageup-hover-bg-color' => 'Background Color Hover',
    'areas.general.pageUpButton.options.gx-pageup-align-left' => 'Align Button left',
    'areas.general.pageUpButton.options.gx-pageup-vertical-space-bottom' => 'Vertical Spacing',

    'areas.general.buttons.title' => 'Buttons',
    'areas.general.buttons.options.gx-btn-border-radius' => 'Border Radius',
    'areas.general.buttons.options.gx-btn-text-transform' => 'Text Transformation',
    'areas.general.buttons.options.gx-btn-primary-color' => 'Font Color',
    'areas.general.buttons.options.gx-btn-primary-bg' => 'Background Primary Button',
    'areas.general.buttons.options.gx-btn-primary-border' => 'Border Color Primary Button',
    'areas.general.buttons.options.gx-btn-default-color' => 'Font Color',
    'areas.general.buttons.options.gx-btn-default-bg' => 'Default-Button Background',
    'areas.general.buttons.options.gx-btn-default-border' => 'Background Default Button',
    'areas.general.buttons.general-fieldset.title' => 'General',
    'areas.general.buttons.primary-fieldset.title'=> 'Primary',
    'areas.general.buttons.default-fieldset.title'=> 'Default',
    'areas.general.buttons.add-to-cart-fieldset.title' => 'Add to Cart',
    'areas.general.buttons.options.gx-btn-calltoaction-color' => 'Font Color',
    'areas.general.buttons.options.gx-btn-calltoaction-bg' => 'Background Add to Cart Button',
    'areas.general.buttons.options.gx-btn-calltoaction-border' => 'Border Color Add to Cart Button',

    'areas.general.borders.title' => 'Borders',
    'areas.general.borders.options.gx-headline-border-color' => 'Headline Separator Color',
    'areas.general.borders.options.gx-footer-boxes-border-color' => 'Footer Boxes Separator Color',
    'areas.general.borders.options.gx-checkout-headline-border-color' => 'Checkout Headline Border Color',
    'areas.general.borders.options.gx-pagination-border-color' => 'Checkout Headlines Separator Color',
    'areas.general.borders.options.gx-product-list-border-color' => 'Product list and Grid Separator Color',
    'areas.general.borders.options.gx-product-info-border-color' => 'Product Info Details Box Separator Color',

    'areas.general.alerts.title' => 'Alerts',
    'areas.general.alerts.options.gx-alert-danger-color' => 'Text Color Error',
    'areas.general.alerts.options.gx-alert-success-color' => 'Text Color Success',
    'areas.general.alerts.options.gx-alert-info-color' => 'Text Color Info',
    'areas.general.alerts.options.gx-alert-warning-color' => 'Text Color Warning',
    'areas.general.alerts.options.gx-alert-danger-border' => 'Border Color Error',
    'areas.general.alerts.options.gx-alert-success-border' => 'Border Color Success',
    'areas.general.alerts.options.gx-alert-info-border' => 'Border Color Info',
    'areas.general.alerts.options.gx-alert-warning-border' => 'Border Color Warning',
    'areas.general.alerts.options.gx-alert-danger-bg' => 'Background Color Error',
    'areas.general.alerts.options.gx-alert-success-bg' => 'Background Color Success',
    'areas.general.alerts.options.gx-alert-warning-bg' => 'Background Color Warning',
    'areas.general.alerts.options.gx-alert-info-bg' => 'Background Color Info',

    'areas.general.qrCodes.title' => 'QR-Code',
    'areas.general.qrCodes.options.gx-qr-code-color' => 'QR-Code Color',
    'areas.general.qrCodes.options.gx-qr-code-bg-color' => 'QR-Codes Background Color',

    'areas.general.modals.title' => 'Modal Windows',
    'areas.general.modals.options.gx-modal-bg' => 'Background',

    'areas.header.general.title' => 'General',
    'areas.header.general.options.gx-header-bg' => 'Background',
    'areas.header.general.options.gx-header-bg-mobile' => 'Background Mobil',
    'areas.header.general.options.gx-header-bg-sticky' => 'Background Sticky',
    'areas.header.general.options.gx-header-height' => 'Height',
    'areas.header.general.options.gx-header-height-mobile' => 'Height Mobil',
    'areas.header.general.options.gx-header-height-sticky' => 'Height Sticky',
    'areas.header.general.options.gx-menu-mobile-icon-color' => 'Menu Icon color Mobile',

    'areas.header.logo.title' => 'Logo',
    'areas.header.logo.options.gx-hide-logo-col' => 'Hide Logo',
    'areas.header.logo.options.gx-header-col-sm' => 'Grid Columns Small',
    'areas.header.logo.options.gx-header-col-md' => 'Grid Columns Medium',
    'areas.header.logo.options.gx-header-col-lg' => 'Grid Columns Large',
    'areas.header.logo.options.gx-brand-height' => 'Logo Height',
    'areas.header.logo.options.gx-brand-width-mobile' => 'Logo Max-Width Mobile',
    'areas.header.logo.options.gx-brand-height-sticky' => 'Logo Height Sticky',

    'areas.header.search.title' => 'Search',
    'areas.header.search.options.gx-show-search-top-nav' => 'Show Search in Top Navigation',
    'areas.header.search.options.gx-hide-search-col' => 'Hide Search',
    'areas.header.search.options.gx-search-mobile-icon-color' => 'Search Icon color Mobile',
    'areas.header.search.options.gx-search-height' => 'Search Height',
    'areas.header.search.options.gx-search-height-sticky' => 'Search Height Sticky',
    'areas.header.search.options.gx-search-padding-vertical' => 'Vertical Spacing',
    'areas.header.search.options.gx-search-padding-vertical-sticky' => 'Vertical Spacing Sticky',
    'areas.header.search.options.gx-search-margin-vertical' => 'Vertical External Spacing',
    'areas.header.search.options.gx-search-margin-vertical-sticky' => 'Vertical External Spacing Sticky',
    'areas.header.search.options.gx-search-col-sm' => 'Grid Columns Small',
    'areas.header.search.options.gx-search-col-md' => 'Grid Columns Medium',
    'areas.header.search.options.gx-search-col-lg' => 'Grid Columns Large',

    'areas.header.customContent.title' => 'Custom Content',
    'areas.header.customContent.options.gx-hide-custom-1-col' => 'Hide Custom Content',
    'areas.header.customContent.options.gx-custom-1-col-height' => 'Height',
    'areas.header.customContent.options.gx-custom-1-col-height-sticky' => 'Height Sticky',
    'areas.header.customContent.options.gx-header-custom-col-sm' => 'Grid Columns Small',
    'areas.header.customContent.options.gx-header-custom-col-md' => 'Grid Columns Medium',
    'areas.header.customContent.options.gx-header-custom-col-lg' => 'Grid Columns Large',

    'areas.header.smallShoppingCart.title' => 'Small Shopping Cart',
    'areas.header.smallShoppingCart.options.gx-hide-cart-col' => 'Hide Cart',
    'areas.header.smallShoppingCart.options.gx-cart-icon-color' => 'Icon color',
    'areas.header.smallShoppingCart.options.gx-cart-sticky-icon-color' => 'Icon color Sticky',
    'areas.header.smallShoppingCart.options.gx-cart-mobile-icon-color' => 'Icon color Mobile',
    'areas.header.smallShoppingCart.options.gx-cart-text-color' => 'Text color',
    'areas.header.smallShoppingCart.options.gx-cart-sticky-text-color' => 'Text color Sticky',
    'areas.header.smallShoppingCart.options.gx-cart-height' => 'Height',
    'areas.header.smallShoppingCart.options.gx-cart-height-sticky' => 'Height Sticky',
    'areas.header.smallShoppingCart.options.gx-cart-padding-vertical' => 'Vertical Spacing',
    'areas.header.smallShoppingCart.options.gx-cart-padding-vertical-sticky' => 'Vertical Spacing Sticky',
    'areas.header.smallShoppingCart.options.gx-cart-margin-vertical' => 'Vertical External Spacing',
    'areas.header.smallShoppingCart.options.gx-cart-margin-vertical-sticky' => 'Vertical External Spacing Sticky',
    'areas.header.smallShoppingCart.options.gx-cart-col-sm' => 'Grid Columns Small',
    'areas.header.smallShoppingCart.options.gx-cart-col-md' => 'Grid Columns Medium',
    'areas.header.smallShoppingCart.options.gx-cart-col-lg' => 'Grid Columns Large',

    'areas.columnDistribution.title' => 'Column Distribution',
    'areas.columnDistribution.desktops.title' => 'Large (Desktops)',
    'areas.columnDistribution.desktops.options.gx-left-col-lg' => 'Left Grid Columns Large',
    'areas.columnDistribution.desktops.options.gx-right-col-lg' => 'Right Grid Columns Large',
    'areas.columnDistribution.desktops.options.gx-main-col-lg' => 'Main Grid Columns Large',

    'areas.columnDistribution.medium.title' => 'Medium (Tablet Landscape)',
    'areas.columnDistribution.medium.options.gx-left-col-md' => 'Left Grid Columns Medium',
    'areas.columnDistribution.medium.options.gx-right-col-md' => 'Right Grid Columns Medium',
    'areas.columnDistribution.medium.options.gx-main-col-md' => 'Main Grid Columns Medium',

    'areas.columnDistribution.small.title' => 'Small (Tablet Portrait)',
    'areas.columnDistribution.small.options.gx-left-col-sm' => 'Left Grid Columns Small',
    'areas.columnDistribution.small.options.gx-right-col-sm' => 'Right Grid Columns Small',
    'areas.columnDistribution.small.options.gx-main-col-sm' => 'Main Grid Columns Small',

    'areas.columnDistribution.subCategories.title' => 'Subcategories',
    'areas.columnDistribution.subCategories.options.gx-sub-cat-col-sm' => 'Grid Columns Subcategories Small',
    'areas.columnDistribution.subCategories.options.gx-sub-cat-col-md' => 'Grid Columns Subcategories Medium',
    'areas.columnDistribution.subCategories.options.gx-sub-cat-col-lg' => 'Grid Columns Subcategories Large',

    'areas.footer.footerHeader.title' => 'Footer Header',
    'areas.footer.footerHeader.options.gx-footer-header-min-height' => 'Minimum Height',
    'areas.footer.footerHeader.options.gx-footer-header-color' => 'Font Color',
    'areas.footer.footerHeader.options.gx-footer-header-bg' => 'Background',

    'areas.footer.footerBody.title' => 'Footer Body',
    'areas.footer.footerBody.options.gx-footer-min-height' => 'Minimum Height',
    'areas.footer.footerBody.options.gx-footer-height' => 'Height',
    'areas.footer.footerBody.options.gx-footer-color' => 'Font Color',
    'areas.footer.footerBody.options.gx-footer-link-color' => 'Link Font Color Footer',
    'areas.footer.footerBody.options.gx-footer-link-hover-color' => 'Link Hover Font Color Footer',
    'areas.footer.footerBody.options.gx-footer-line-height' => 'Line Height Footer',
    'areas.footer.footerBody.options.gx-footer-bg' => 'Background',

    'areas.footer.footerColumn1.title' => 'Footer Column 1',
    'areas.footer.footerColumn1.options.gx-hide-footer-col-1' => 'Hide Column 1',
    'areas.footer.footerColumn1.options.gx-footer-col-1-xs' => 'Grid Columns Large',
    'areas.footer.footerColumn1.options.gx-footer-col-1-sm' => 'Grid Columns Medium',
    'areas.footer.footerColumn1.options.gx-footer-col-1-lg' => 'Grid Columns Small',

    'areas.footer.footerColumn2.title' => 'Footer Column 2',
    'areas.footer.footerColumn2.options.gx-hide-footer-col-2' => 'Hide Column 2',
    'areas.footer.footerColumn2.options.gx-footer-col-2-xs' => 'Grid Columns Large',
    'areas.footer.footerColumn2.options.gx-footer-col-2-sm' => 'Grid Columns Medium',
    'areas.footer.footerColumn2.options.gx-footer-col-2-lg' => 'Grid Columns Small',

    'areas.footer.footerColumn3.title' => 'Footer Column 3',
    'areas.footer.footerColumn3.options.gx-hide-footer-col-3' => 'Hide Column 3',
    'areas.footer.footerColumn3.options.gx-footer-col-3-xs' => 'Grid Columns Large',
    'areas.footer.footerColumn3.options.gx-footer-col-3-sm' => 'Grid Columns Medium',
    'areas.footer.footerColumn3.options.gx-footer-col-3-lg' => 'Grid Columns Small',

    'areas.footer.default.title' => 'Default',
    'areas.footer.default.thumbnail' => '\/\/placehold.it\/800x150?text=Default',

    'areas.footer.footerColumn4.title' => 'Footer Column 4',
    'areas.footer.footerColumn4.options.gx-hide-footer-col-4' => 'Hide Column 4',
    'areas.footer.footerColumn4.options.gx-footer-col-4-xs' => 'Grid Columns Large',
    'areas.footer.footerColumn4.options.gx-footer-col-4-sm' => 'Grid Columns Medium',
    'areas.footer.footerColumn4.options.gx-footer-col-4-lg' => 'Grid Columns Small',

    'areas.products.title' => 'Products',
    'areas.products.articleImage.title' => 'Product Image',
    'areas.products.articleImage.options.gx-product-info-stage-height' => 'Height',
    'areas.products.articleImage.options.gx-product-info-stage-height-mobile' => 'Height Mobile',
    'areas.products.articleImage.options.gx-product-info-layer-stage-height' => 'Height Lightbox',
    'areas.products.articleImage.options.gx-product-info-layer-stage-height-mobile' => 'Height Lightbox Mobile',
    'areas.products.articleImage.options.gx-product-info-thumbnail-width' => 'Thumbnails Width',
    'areas.products.articleImage.options.gx-product-info-thumbnail-width-mobile' => 'Thumbnails Width Mobile',
    'areas.products.articleImage.options.gx-product-info-img-bg' => 'Background Color',

    'areas.products.productList.title' => 'Product Listing',
    'areas.products.productList.options.gx-product-bg' => 'Background',
    'areas.products.productList.options.gx-gallery-bg' => 'Background of the Gallery',
    'areas.products.productList.options.gx-product-listing-col-xs' => 'Grid Columns Mobile',
    'areas.products.productList.options.gx-product-listing-col-sm' => 'Grid Columns Small',
    'areas.products.productList.options.gx-product-listing-col-md' => 'Grid Columns Medium',
    'areas.products.productList.options.gx-product-listing-col-lg' => 'Grid Columns Large',
    'areas.products.productList.options.gx-products-name-height' => 'Height For Product Name In Tile',
    'areas.products.productList.options.gx-products-price-height' => 'Height For Price Container in Tile',
    'areas.products.productList.options.gx-ribbons-padding' => 'Space Between Product Image And Ribbons',
    'areas.products.productList.options.gx-product-listing-image-height' => 'Image Height Grid',
    'areas.products.productList.options.gx-product-listing-image-height-mobile' => 'Image Height Grid mobil',
    'areas.products.productList.options.gx-product-listing-gallery-image-height' => 'Height Gallery Image Flyover',
    'areas.products.productList.options.gx-product-listing-gallery-width' => 'Gallery Width',
    'areas.products.productList.options.gx-show-shipping-in-tile' => 'Always Show Shipping Time in Tile',

    'areas.products.tabs.title' => 'Tabs',
    'areas.products.tabs.options.gx-tab-color' => 'Text Color',
    'areas.products.tabs.options.gx-tab-color-active' => 'Text Color active Tab',
    'areas.products.tabs.options.gx-tab-border-color' => 'Border Color',
    'areas.products.tabs.options.gx-tab-border-color-active' => 'Border Color active Tab',
    'areas.products.tabs.options.gx-tab-container-border-color' => 'Border Color Tab Container',
    'areas.products.tabs.options.gx-tab-bg' => 'Background',
    'areas.products.tabs.options.gx-tab-bg-active' => 'Background active Tab',

    'areas.products.ribbons.title' => 'Ribbons',
    'areas.products.ribbons.options.gx-ribbon-new-active' => 'Show New',
    'areas.products.ribbons.options.gx-ribbon-new-bg' => 'Background Color New',
    'areas.products.ribbons.options.gx-ribbon-new-color' => 'Text Color New',
    'areas.products.ribbons.options.gx-ribbon-special-active' => 'Show Special',
    'areas.products.ribbons.options.gx-ribbon-special-bg' => 'Background Color Special',
    'areas.products.ribbons.options.gx-ribbon-special-color' => 'Text Color Special',
    'areas.products.ribbons.options.gx-ribbon-available-active' => 'Show Soon',
    'areas.products.ribbons.options.gx-ribbon-available-bg' => 'Background Color Soon',
    'areas.products.ribbons.options.gx-ribbon-available-color' => 'Text Color Soon',
    'areas.products.ribbons.options.gx-ribbon-recommendation-active' => 'Show Top',
    'areas.products.ribbons.options.gx-ribbon-recommendation-bg' => 'Background Color Top',
    'areas.products.ribbons.options.gx-ribbon-recommendation-color' => 'Text Color Top',
    'areas.products.ribbons.options.gx-ribbon-sold-out-active' => 'Show Sold out',
    'areas.products.ribbons.options.gx-ribbon-sold-out-bg' => 'Background Color Sold out',
    'areas.products.ribbons.options.gx-ribbon-sold-out-color' => 'Text Color Sold out',

    'areas.checkout.title' => 'Checkout',
    'areas.checkout.general.title' => 'General',
    'areas.checkout.general.gx-checkout-headline-color' => 'Headline Color',

    'areas.checkout.shoppingCart.title' => 'Shopping Cart',
    'areas.checkout.shoppingCart.options.gx-cart-border-color' => 'Border Color',
    'areas.checkout.shoppingCart.options.gx-cart-table-head-color' => 'Text Color Table Head',
    'areas.checkout.shoppingCart.options.gx-cart-table-color' => 'Text Color Table Body',
    'areas.checkout.shoppingCart.options.gx-cart-table-info-color' => 'Text Color Product Information',

    'areas.checkout.shoppingCartTotalBox.title' => 'Shopping Cart Summary Box',
    'areas.checkout.shoppingCartTotalBox.options.gx-total-box-color' => 'Text Color',
    'areas.checkout.shoppingCartTotalBox.options.gx-total-box-border-color' => 'Border Color',
    'areas.checkout.shoppingCartTotalBox.options.gx-total-box-top-bg' => 'Background top',
    'areas.checkout.shoppingCartTotalBox.options.gx-total-box-bottom-bg' => 'Background bottom',

    'areas.checkout.checkoutTotalTable.title' => 'Checkout Total Table',
    'areas.checkout.checkoutTotalTable.options.gx-checkout-table-color' => 'Text Color',
    'areas.checkout.checkoutTotalTable.options.gx-checkout-table-header-color' => 'Text Color Header',
    'areas.checkout.checkoutTotalTable.options.gx-checkout-table-additional-info-color' => 'Text Color Additional Information',
    'areas.checkout.checkoutTotalTable.options.gx-checkout-table-border-color' => 'Border Color',
    'areas.checkout.checkoutTotalTable.options.gx-checkout-table-bg' => 'Background Color',

    'areas.checkout.listGroupItems.title' => 'List Elements',
    'areas.checkout.listGroupItems.gx-list-group-item-color' => 'Text Color',
    'areas.checkout.listGroupItems.gx-list-group-item-color-active' => 'Text Color active Selection',
    'areas.checkout.listGroupItems.gx-list-group-item-link-color' => 'Link Color',
    'areas.checkout.listGroupItems.gx-list-group-item-link-color-active' => 'Link Color active Selection',
    'areas.checkout.listGroupItems.gx-list-group-item-border-color' => 'Border Color',
    'areas.checkout.listGroupItems.gx-list-group-item-border-color-active' => 'Border Color active Selection',
    'areas.checkout.listGroupItems.gx-list-group-item-bg' => 'Background',
    'areas.checkout.listGroupItems.gx-list-group-item-bg-active' => 'Background active Selection',
    'areas.checkout.listGroupItems.gx-checkout-form-bg' => 'Background form',

    'areas.checkout.checkboxes.title' => 'GTC and Withdrawal Checkboxes',
    'areas.checkout.checkboxes.options.gx-checkbox-color' => 'Text Color Checkboxes',
    'areas.checkout.checkboxes.options.gx-checkbox-active-color' => 'Text Color Checkboxes Active',
    'areas.checkout.checkboxes.options.gx-checkbox-border' => 'Border Color Checkbox',
    'areas.checkout.checkboxes.options.gx-checkbox-active-border' => 'Border Color Checkbox Active',
    'areas.checkout.checkboxes.options.gx-checkbox-bg' => 'Background Checkboxes',
    'areas.checkout.checkboxes.options.gx-checkbox-active-bg' => 'Background Checkboxes Active',

    'areas.menuBoxes.title' => 'Menu Boxes',
    'areas.menuBoxes.panelHeader.title' => 'Header',
    'areas.menuBoxes.panelHeader.options.gx-panel-header-color' => 'Text Color',
    'areas.menuBoxes.panelHeader.options.gx-panel-header-bg' => 'Background',

    'areas.menuBoxes.panelBody.title' => 'Content',
    'areas.menuBoxes.panelBody.options.gx-panel-bg' => 'Background',
    'areas.menuBoxes.panelBody.options.gx-panel-border-color' => 'Border Color',

    'areas.menuBoxes.activeAt.title' => 'Activate menu boxes on',
    'areas.menuBoxes.activeAt.options.gx-index-full-width' => 'Start Page',
    'areas.menuBoxes.activeAt.options.gx-advanced-search-result-full-width' => 'Search Result Page',
    'areas.menuBoxes.activeAt.options.gx-shop-content-full-width' => 'Content Manager Page',
    'areas.menuBoxes.activeAt.options.gx-product-info-full-width' => 'Product Page',
    'areas.menuBoxes.activeAt.options.gx-product-listing-full-width' => 'Categories and Product Listings',
    'areas.menuBoxes.activeAt.options.gx-shopping-cart-full-width' => 'Shopping Cart',
    'areas.menuBoxes.activeAt.options.gx-wishlist-full-width' => 'Wishlist',
    'areas.menuBoxes.activeAt.options.gx-checkout-full-width' => 'Checkout',
    'areas.menuBoxes.activeAt.options.gx-account-full-width' => 'Customer Account Pages',
    'areas.menuBoxes.activeAt.options.gx-create-account-full-width' => 'Account Creation',
    'areas.menuBoxes.activeAt.options.gx-newsletter-full-width' => 'Newsletter Sign up',
    'areas.menuBoxes.activeAt.options.gx-logoff-full-width' => 'Logoff',
    'areas.menuBoxesPosition.title' => 'Selection and Positions',
    'areas.menuBoxesPosition.category.title' => 'Categories',
    'areas.menuBoxesPosition.filter.title' => 'Filter',
    'areas.menuBoxesPosition.admin.title' => 'Admin',
    'areas.menuBoxesPosition.bestseller.title' => 'Bestseller',
    'areas.menuBoxesPosition.moreAbout.title' => 'More about',
    'areas.menuBoxesPosition.orderHistory.title' => 'Order history',
    'areas.menuBoxesPosition.trustedShopsWidget.title' => 'Trusted Shops Widget',
    'areas.menuBoxesPosition.newsletter.title' => 'Newsletter',
    'areas.menuBoxesPosition.specials.title' => 'Special offers',
    'areas.menuBoxesPosition.manufacturer.title' => 'Manufacturer',
    'areas.menuBoxesPosition.manufacturerInfo.title' => 'Manufacturer Info',
    'areas.menuBoxesPosition.search.title' => 'Search',
    'areas.menuBoxesPosition.addQuickie.title' => 'Quick Purchase',
    'areas.menuBoxesPosition.whatsNew.title' => 'New products',
    'areas.menuBoxesPosition.lastViewed.title' => 'Last viewed',
    'areas.menuBoxesPosition.login.title' => 'Log in',
    'areas.menuBoxesPosition.trustedShops.title' => 'Trusted Shops',
    'areas.menuBoxesPosition.information.title' => 'Information',
    'areas.menuBoxesPosition.paypal.title' => 'Paypal',
    'areas.menuBoxesPosition.paypalInstallments.title' => 'Payment by installments powered By PayPal',
    'areas.menuBoxesPosition.ekomi.title' => 'eKomi',
    'areas.menuBoxesPosition.mailbeezShopvoting.title' => 'MailBeez Reviews',
    'areas.menuBoxesPosition.extrabox1.title' => 'Additional Box 1',
    'areas.menuBoxesPosition.extrabox2.title' => 'Additional Box 2',
    'areas.menuBoxesPosition.extrabox3.title' => 'Additional Box 3',
    'areas.menuBoxesPosition.extrabox4.title' => 'Additional Box 4',
    'areas.menuBoxesPosition.extrabox5.title' => 'Additional Box 5',
    'areas.menuBoxesPosition.extrabox6.title' => 'Additional Box 6',
    'areas.menuBoxesPosition.extrabox7.title' => 'Additional Box 7',
    'areas.menuBoxesPosition.extrabox8.title' => 'Additional Box 8',
    'areas.menuBoxesPosition.extrabox9.title' => 'Additional Box 9',

    // Cookie Consent Panel
    'areas.cookieConsentPanel.title'                                 => 'Cookie Consent Panel',
    'areas.cookieConsentPanel.title.general'                         => 'General',
    'areas.cookieConsentPanel.options.panel.background.color'        => 'Background Color',
    'areas.cookieConsentPanel.options.panel.opacity'                 => 'Opacity',
    'areas.cookieConsentPanel.options.panel.switchers.color'         => 'Switchers Color',
    'areas.cookieConsentPanel.options.panel.buttons.color'           => 'Buttons Color',
    'areas.cookieConsentPanel.options.panel.buttons.color.hover'     => 'Buttons Hover Color',
    'areas.cookieConsentPanel.options.panel.boxshadow'               => 'Box Shadow',
    'areas.cookieConsentPanel.options.panel.headline.font-size'      => 'Headline Font Size',
    'areas.cookieConsentPanel.options.panel.headline.font-family'    => 'Headline Font Family',
    'areas.cookieConsentPanel.options.panel.description.font-size'   => 'Description Font Size',
    'areas.cookieConsentPanel.options.panel.description.font-family' => 'Description Font Family',

    'category' => 'Categories',
    'price_min' => 'from',
    'price_max' => 'to',
    
    'areas.products.productDetailBox.gx-product-info-hide-quantity-input' => 'Hide quantity input',

    'areas.general.buttons.general' => 'General',
    'areas.variants.title' => 'Variants',
    
    /**
     * HEADER VARIANTS
     */
    'areas.header.variants.default.title' => 'Standard',
    'areas.header.variants.header1.title' => 'Header 1',
    'areas.header.variants.header2.title' => 'Header 2',
    'areas.header.variants.header3.title' => 'Header 3',
    'areas.header.variants.header4.title' => 'Header 4',
    'areas.header.variants.header5.title' => 'Header 5',
    'areas.header.variants.header6.title' => 'Header 6',
    'areas.header.variants.header7.title' => 'Header 7',

    /**
     * SLIDER VARIANTS
     */
    'areas.slider.title' => 'Teaser-Slider',
    'areas.slider.variants.title' => 'Variants',
    'areas.slider.variants.default.title' => 'Classic',
    'areas.slider.variants.slider1.title' => 'Boxed',
    'areas.slider.variants.slider2.title' => 'Full width',
    'areas.slider.variants.general.title' => 'General',
    
    /**
     * LAYOUT VARIANTS
     */
    'areas.layout.title' => 'Layout',
    'areas.layout.variants.title' => 'Variants',
    'areas.layout.variants.general.title' => 'General',
    'areas.layout.variants.bordered.title' => 'Bordered',
    'areas.layout.variants.boxed.title' => 'Boxed',
    'areas.layout.variants.fullscreen.title' => 'Fullscreen',
    'areas.layout.variants.hero.title' => 'Hero',
    'areas.general.layout.options.gx-use-content-zone-for-hero' => 'Content Zone instead of Slider',
    
    /**
     * PRODUCT PAGE VARIANTS
     */
    'areas.product.title' => 'Product Page',
    'areas.product.variants.general.title' => 'General',
    'areas.product.variants.default.title' => 'Left Alignment',
    'areas.product.variants.classic.title' => 'Classic',
    
    "areas.header.general.layout.title" => "Layout",
    "areas.header.general.layout.options.gx-hide-topbar" => "Hide top navigation",
    "areas.header.general.layout.options.gx-hide-categories-col" => "Hide categories",
    "areas.header.general.layout.options.gx-hide-secondary-col" => "Hide secondary navigation",
    
    'areas.header.secondaryCol.title' => 'Secondary Column',
    'areas.header.secondaryCol.general.title' => 'General',
    'areas.header.secondaryCol.general.options.gx-secondary-font-size' => 'Font size',
    'areas.header.secondaryCol.general.options.gx-secondary-height' => 'Height',
    'areas.header.secondaryCol.general.options.gx-secondary-height-sticky' => 'Height Sticky',
    'areas.header.secondaryCol.general.options.gx-secondary-padding-vertical' => 'Vertical Padding',
    'areas.header.secondaryCol.general.options.gx-secondary-padding-vertical-sticky' => 'Vertical Padding Sticky',
    'areas.header.secondaryCol.general.options.gx-secondary-margin-vertical' => 'Vertical Margin',
    'areas.header.secondaryCol.general.options.gx-secondary-margin-vertical-sticky' => 'Vertical Margin Sticky',
    'areas.header.secondaryCol.general.options.gx-secondary-bg' => 'Background',
    'areas.header.secondaryCol.general.options.gx-secondary-show-icons' => 'Show icons',
    'areas.header.secondaryCol.general.options.gx-header-secondary-col-sm' => 'Grid Columns Small',
    'areas.header.secondaryCol.general.options.gx-header-secondary-col-md' => 'Grid Columns Medium',
    'areas.header.secondaryCol.general.options.gx-header-secondary-col-lg' => 'Grid Columns Large',
    'areas.header.secondaryCol.menuItems.title' => 'Menu items',
    'areas.header.secondaryCol.menuItems.options.gx-secondary-link-color' => 'Font color',
    'areas.header.secondaryCol.menuItems.options.gx-secondary-link-hover-color' => 'Font color hover',
    'areas.header.secondaryCol.menuItems.options.gx-secondary-link-active-color' => 'Font color active',
    'areas.header.secondaryCol.menuItems.options.gx-secondary-link-bg' => 'Background',
    'areas.header.secondaryCol.menuItems.options.gx-secondary-link-hover-bg' => 'Background hover',
    'areas.header.secondaryCol.menuItems.options.gx-secondary-link-active-bg' => 'Background active',
    'areas.header.secondaryCol.menuItems.options.gx-secondary-link-padding' => 'Padding',

    'areas.header.secondaryNavigation.title' => 'Secondary Navigation',
    'areas.header.secondaryNavigation.general.title' => 'General',
    'areas.header.secondaryNavigation.general.options.gx-secondary-height' => 'Height',
    'areas.header.secondaryNavigation.general.options.gx-secondary-height-sticky' => 'Height Sticky',

    'areas.header.categoriesCol.title' => 'Categories Column',
    'areas.header.categoriesCol.general.title' => 'General',
    'areas.header.categoriesCol.general.options.gx-categories-col-height' => 'Height',
    'areas.header.categoriesCol.general.options.gx-categories-col-height-sticky' => 'Height Sticky',
    'areas.header.categoriesCol.general.options.gx-cart-padding-vertical' => 'Cart Vertical Padding',
    'areas.header.categoriesCol.general.options.gx-cart-padding-vertical-sticky' => 'Cart Vertical Padding Sticky',
    'areas.header.categoriesCol.general.options.gx-cart-margin-vertical' => 'Cart Vertical Margin',
    'areas.header.categoriesCol.general.options.gx-cart-margin-vertical-sticky' => 'Cart Vertical Margin Sticky',
    'areas.header.categoriesCol.general.options.gx-header-categories-col-sm' => 'Grid Columns Small',
    'areas.header.categoriesCol.general.options.gx-header-categories-col-md' => 'Grid Columns Medium',
    'areas.header.categoriesCol.general.options.gx-header-categories-col-lg' => 'Grid Columns Large',

    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-background-color' => 'Overlay background color',
    'areas.header.categories.categories-mobile.gx-mobile-menu-close-icon-color' => 'Close icon color',
    'areas.header.categories.categories-mobile.gx-mobile-menu-close-icon-color-active' => 'Focused close icon color',

    'areas.header.categories.categories-mobile.menu-items' => 'Menu Items',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-items-color' => 'Link color',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-items-background-color' => 'Link background',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-items-color-active' => 'Active link color',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-items-background-color-active' => 'Active link background',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-menu-borders-color' => 'Border color',

    'areas.header.categories.categories-mobile.search-form' => 'Search Form',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-search-rounded' => 'Rounded borders',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-search-text-color' => 'Search text color',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-search-text-color-active' => 'Focused search text color',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-search-background-color' => 'Background color',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-search-background-color-active' => 'Focused background color',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-search-borders-color' => 'Border color',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-search-borders-color-active' => 'Focused border color',
    'areas.header.categories.categories-mobile.gx-mobile-menu-overlay-search-icon-color' => 'Icon color',

    /**
     * PRODUCT MODIFIERS VARIANTS
     */
    'areas.product-modifiers.title' => 'Product Modifiers',
    'areas.product-modifiers.square.title' => 'Square',
    'areas.product-modifiers.rounded.title' => 'Rounded',
    'areas.product-modifiers.rounded.border-radius.title' => 'Modifiers Border Radius',
    'areas.product-modifiers.rounded.image' => 'Image',
    'areas.product-modifiers.rounded.boxed-text' => 'Boxed Text',
    'areas.product-modifiers.rounded.dropdown' => 'Dropdown',
    'areas.product-modifiers.rounded.text' => 'Text',
    'areas.product-modifiers.rounded.radio' => 'Radio',

    /**
     * FOOTER VARIANTS
     */
    'areas.footer.variants.default.title' => 'Default',
    'areas.footer.variants.no-columns.title' => 'No columns',
    'areas.footer.variants.individual.title' => 'Individual',

    /**
     * AREAS > GENERAL > BUTTONS
     */
    'areas.general.buttons.options.gx-btn-rounded' => 'Rounded buttons',
    'areas.general.buttons.options.gx-btn-borderless' => 'Borderless buttons',

    'areas.categories.categoriesMobile.options.gx-categories-mobile-height' => 'Height',
    'areas.categories.categoriesMobile.options.gx-categories-mobile-icons' => 'Display Icons',
    'areas.categories.categoriesMobile.options.gx-categories-mobile-padding-vertical' => 'Vertical Spacing',
    'areas.categories.categoriesMobile.options.navbar-collapse-max-height' => 'Categories Mobile Height',
    'areas.categories.categoriesMobile.title' => 'Categories Mobile',
    'areas.categories.general.options.gx-categories-height' => 'Height',
    'areas.categories.general.options.gx-categories-height-sticky' => 'Height Sticky',
    'areas.categories.general.options.gx-categories-transitions' => 'Transitions',
    'areas.categories.general.options.navbar-height' => 'Height outside',
    'areas.categories.general.options.navbar-margin-bottom' => 'Bottom margin',
    'areas.categories.general.title' => 'General',
    'areas.categories.megaDropdown.options.gx-categories-tab-padding' => 'Tab Shifting',
    'areas.categories.megaDropdown.options.gx-enter-category-bg' => 'Background Color Show All',
    'areas.categories.megaDropdown.options.gx-enter-category-color' => 'Text Color Show All',
    'areas.categories.megaDropdown.options.gx-megadropdown-bg' => 'Background',
    'areas.categories.megaDropdown.options.gx-megadropdown-block-count' => 'Block Number',
    'areas.categories.megaDropdown.options.gx-megadropdown-block-width' => 'Block Width',
    'areas.categories.megaDropdown.options.gx-megadropdown-color' => 'Font Color',
    'areas.categories.megaDropdown.options.gx-megadropdown-heading-border-color' => 'Border Color',
    'areas.categories.megaDropdown.options.gx-megadropdown-heading-font-size' => 'Font Size Headlines',
    'areas.categories.megaDropdown.title' => 'Mega-Dropdown',
    'areas.categories.menuItems.options.gx-cat-navbar-bg' => 'Background',
    'areas.categories.menuItems.options.gx-categories-bg' => 'External Background',
    'areas.categories.menuItems.options.gx-categories-headline-size' => 'Font Size',
    'areas.categories.menuItems.options.gx-categories-text-transformation' => 'Text Transformation',
    'areas.categories.menuItems.options.gx-custom-bg-color' => 'Background Custom',
    'areas.categories.menuItems.options.gx-custom-bg-color-active' => 'Background active Custom',
    'areas.categories.menuItems.options.gx-custom-bg-color-hover' => 'Background hover Custom',
    'areas.categories.menuItems.options.gx-custom-color' => 'Font Color Custom',
    'areas.categories.menuItems.options.gx-custom-color-active' => 'Font Color active Custom',
    'areas.categories.menuItems.options.gx-custom-color-hover' => 'Font Color Hover Custom',
    'areas.categories.menuItems.options.navbar-default-link-active-bg' => 'Background active',
    'areas.categories.menuItems.options.navbar-default-link-active-color' => 'Font Color active',
    'areas.categories.menuItems.options.navbar-default-link-color' => 'Font Color',
    'areas.categories.menuItems.options.navbar-default-link-hover-bg' => 'Background hover',
    'areas.categories.menuItems.options.navbar-default-link-hover-color' => 'Font Color Hover',
    'areas.categories.menuItems.options.navbar-padding-horizontal' => 'Horizontal Spacing',
    'areas.categories.menuItems.options.navbar-padding-vertical' => 'Horizontal Spacing',
    'areas.categories.menuItems.title' => 'Menu Items',
    'areas.categories.title' => 'Categories',
    'areas.categories.verticalCategorieMenu.options.gx-cat-left-active-color' => 'Text Color Active',
    'areas.categories.verticalCategorieMenu.options.gx-cat-left-bg' => 'Background',
    'areas.categories.verticalCategorieMenu.options.gx-cat-left-bg-active' => 'Background Active',
    'areas.categories.verticalCategorieMenu.options.gx-cat-left-bg-hover' => 'Background Hover',
    'areas.categories.verticalCategorieMenu.options.gx-cat-left-bg-open' => 'Background Open',
    'areas.categories.verticalCategorieMenu.options.gx-cat-left-color' => 'Text Color',
    'areas.categories.verticalCategorieMenu.options.gx-cat-left-hover-color' => 'Text Color Hover',
    'areas.categories.verticalCategorieMenu.options.gx-cat-left-open-color' => 'Text Color Opened',
    'areas.categories.verticalCategorieMenu.title' => 'Vertical Category Menu',
    'areas.general.teaserSlider.gx-display-teaser-slider-lg' => 'Display Teaser Slider Monitor',
    'areas.general.teaserSlider.gx-display-teaser-slider-md' => 'Display Teaser Slider Tablet Landscape',
    'areas.general.teaserSlider.gx-display-teaser-slider-sm' => 'Display Teaser Slider Tablet Portrait',
    'areas.general.teaserSlider.gx-display-teaser-slider-xs' => 'Display Teaser Slider Mobile',
    'areas.products.productDetailBox.gx-product-info-button-bg' => 'Button Background Color',
    'areas.products.productDetailBox.gx-product-info-button-bg-hover' => 'Button Background Color Hover',
    'areas.products.productDetailBox.gx-product-info-button-border' => 'Button Border Color',
    'areas.products.productDetailBox.gx-product-info-button-border-hover' => 'Button Border Color Hover',
    'areas.products.productDetailBox.gx-product-info-button-color' => 'Button Font Color',
    'areas.products.productDetailBox.gx-product-info-button-color-hover' => 'Button Font Color Hover',
    'areas.products.productDetailBox.gx-product-info-details-bg' => 'Background',
    'areas.products.productDetailBox.gx-product-info-details-border-color' => 'Border Color',
    'areas.products.productDetailBox.gx-product-info-details-border-style' => 'Border Style',
    'areas.products.productDetailBox.gx-product-info-details-border-width' => 'Border Width',
    'areas.products.productDetailBox.gx-product-info-details-color' => 'Font Color',
    'areas.products.productDetailBox.gx-product-info-details-note-color' => 'Note Text Color',
    'areas.products.productDetailBox.gx-product-info-details-sticky' => 'Scrolling price box',
    'areas.secondaryNavigation.general.options.gx-navbar-topbar-bg' => 'Background',
    'areas.secondaryNavigation.general.options.gx-navbar-topbar-show-icons' => 'Show Icons',
    'areas.secondaryNavigation.general.options.gx-topbar-font-size' => 'Font Size',
    'areas.secondaryNavigation.general.options.gx-topbar-height' => 'Height',
    'areas.secondaryNavigation.general.options.gx-topbar-height-sticky' => 'Height Sticky',
    'areas.secondaryNavigation.menuItems.options.gx-navbar-topbar-link-active-bg' => 'Background Active',
    'areas.secondaryNavigation.menuItems.options.gx-navbar-topbar-link-active-color' => 'Color Active',
    'areas.secondaryNavigation.menuItems.options.gx-navbar-topbar-link-bg' => 'Background',
    'areas.secondaryNavigation.menuItems.options.gx-navbar-topbar-link-color' => 'Font Color',
    'areas.secondaryNavigation.menuItems.options.gx-navbar-topbar-link-hover-bg' => 'Background Hover',
    'areas.secondaryNavigation.menuItems.options.gx-navbar-topbar-link-hover-color' => 'Color Hover',
    'areas.secondaryNavigation.menuItems.options.gx-topbar-link-padding' => 'Link Spacing',
    'areas.secondaryNavigation.menuItems.title' => 'Menu Items',
];
